

<?php $__env->startSection('title'); ?>
    Ads Rate
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
<div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0 text-dark">Ads Rate</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
            <li class="breadcrumb-item active">All Rates</li>
          </ol>
        </div>
      </div>
    </div>
  </div>
  
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-3">
            <form action="<?php echo e(route('admin.advertisement-rate.store')); ?>" method="POST" novalidate="novalidate" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">New Rate</h3>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="duration">Duration (Days)</label>
                            <input type="number" class="form-control" id="day" name="day" value="0">
                        </div>
 
                        <div class="form-group">
                            <label for="cost">Cost</label>
                            <input type="number" class="form-control" step="0.001" id="cost" name="cost" value="0">
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-success"> <i class="fas fa-save"></i> Submit</button>
                    </div>
                </div>
            </form>
        </div>
        <div class="col-md-9">
          <div class="card card-success">
            <div class="card-header">
              <h3 class="card-title">All Rates</h3>
            </div>
            <div class="card-body">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>Duration</th>
                  <th>Cost</th>
                  <th width="10%">Action</th>
                </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($data->day); ?> days</td>
                            <td><?php echo e($data->cost); ?> $</td>
                            <td>
                                <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#edit_<?php echo e($data->id); ?>"><i class="fas fa-edit"></i></button>
                                <a href="<?php echo e(route('admin.advertisement-rate.delete',$data->id)); ?>" onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm"><i class="fas fa-trash-alt"></i></a>
                            </td>
                        </tr>
                        
                        <div class="modal fade" id="edit_<?php echo e($data->id); ?>" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                            <div class="modal-dialog">
                                <form action="<?php echo e(route('admin.advertisement-rate.update', $data->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Update Rate</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="duration">Duration (Days)</label>
                                                <input type="number" class="form-control" id="day" name="day" value="<?php echo e($data->day); ?>">
                                            </div>
                     
                                            <div class="form-group">
                                                <label for="cost">Cost</label>
                                                <input type="number" class="form-control" step="0.001" id="cost" name="cost" value="<?php echo e($data->cost); ?>">
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Update</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
        </div>
      </div>
      
    </div>
  </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>

    <script>
        $(function () {
          $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
          });
          $('#example2').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
          });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microwo1/public_html/resources/views/backend/pages/system-setting/advertisement-rate.blade.php ENDPATH**/ ?>